<?php include 'header.php'; ?>
<style>
/* Feedback Container */
.feedback-container {
  background-color: #fff;
  border-radius: 5px;
  padding: 25px;
  max-width: 400px;
  margin: 50px auto;
  box-shadow: rgba(0, 0, 0, 0.05) 0px 6px 24px, rgba(0, 22, 105, 0.08) 0px 0px 0px 1px;
}

/* Heading */
.feedback-heading {
  color: #2c3e50;
  text-align: center;
  margin-bottom: 30px;
  font-weight: 600;
  font-size: 22px;
}

/* Labels */
.feedback-label {
  font-weight: 700;
  color: #555;
  margin-bottom: 10px;
  display: block;
}

/* Inputs and Textareas */
.feedback-input,
select.feedback-input {
  width: 100%;
  border: 1px solid transparent;
  border-radius: 4px;
  padding: 8px;
  display: flex;
  align-items: center;
  color: #10122d;
  transition: box-shadow 0.3s ease, border 0.3s ease;
}

.feedback-textarea {
  resize: vertical;
  min-height: 100px;
}

/* Hover Effects */
.feedback-input:hover,
select.feedback-input:hover,
textarea.feedback-input:hover {
  border: 1px solid transparent;
  box-shadow: rgba(0, 0, 0, 0.05) 0px 6px 24px, rgba(0, 22, 105, 0.08) 0px 0px 0px 1px;
}

/* Focus Effects */
.feedback-input:focus,
select.feedback-input:focus,
textarea.feedback-input:focus {
  outline: none;
  border: none;
  box-shadow: rgba(0, 0, 0, 0.1) 0px 6px 24px, rgba(0, 22, 105, 0.12) 0px 0px 0px 2px;
}

/* Button Styles */
.btn-feedback {
  font-weight: 500;
  border-radius: 5px;
  font-size: 1.25rem;
  cursor: pointer;
  padding: 12px 20px;
  width: 100%;
  background-color: #007bff; /* Primary color */
  color: #fff;
  box-shadow: 0 5px 15px -5px rgba(0, 123, 255, 0.6);
  transition: opacity 0.3s ease, box-shadow 0.3s ease;
}

.btn-feedback:hover {
  opacity: 0.9;
  box-shadow: 0 5px 15px -5px rgba(0, 123, 255, 0.8);
}

.btn-feedback:focus,
.btn-feedback:active {
  outline: none;
  border: none;
  box-shadow: 0 4px 12px rgba(0, 123, 255, 0.8);
}

/* Additional Spacing */
.nm {
  padding: 0 20px;
}

.sdk {
  background: #f5e509;
  color: #fff;
  padding: 1px 8px;
  border-radius: 20px;
}

.md {
  margin-bottom: 12px;
  font-size: 16px;
}
</style>
<div class="nm">
    <div class="feedback-container" style="margin-bottom:-20px;padding:4px">
        <h4 class="feedback-heading md">
            Your submissions left for today: 
            <span class="sdk"><?php echo $remainingSubmissions; ?></span>
        </h4>
    </div>
    <div class="feedback-container">
        <h3 class="feedback-heading">GIVE US FEEDBACK! ✨</h3>

        <!-- Success/Error Message -->
        <?php if (isset($errorMessage) || isset($successMessage)): ?>
            <div class="alert <?php echo isset($successMessage) ? 'alert-success' : 'alert-success'; ?>" style="margin-bottom: 20px; text-align: center; border-radius: 4px; padding: 10px;">
                <?php 
                    echo isset($successMessage) ? $successMessage : $errorMessage; 
                ?>
            </div>
        <?php endif; ?>

        <!-- Feedback Form -->
        <form action="admin/feedback" method="post">
            <div class="form-group">
                <label class="feedback-label" for="feedbackTitle">Title:</label>
                <input type="text" class="form-control feedback-input" name="title" id="feedbackTitle" placeholder="Enter feedback title">
            </div>
            <div class="form-group">
                <label class="feedback-label" for="feedbackType">Type:</label>
                <select class="form-control feedback-input" id="feedbackType" name="type">
                    <option value="bug">Bug</option>
                    <option value="suggestion">Suggestion</option>
                    <option value="compliment">Compliment</option>
                    <option value="other">Other</option>
                </select>
            </div>
            <div class="form-group">
                <label class="feedback-label" for="feedbackMessage">Message:</label>
                <textarea class="form-control feedback-input feedback-textarea" id="feedbackMessage" name="message" rows="5" placeholder="Enter your feedback message"></textarea>
            </div>
            <button type="submit" class="btn btn-feedback">Submit Feedback</button>
        </form>
    </div>
</div>
<?php include 'footer.php'; ?>
